IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_Localidades_Duplicadas') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Localidades_Duplicadas
END
GO

CREATE PROCEDURE [dbo].[CPJ_Localidades_Duplicadas] @pJson VARCHAR(8000)
AS 
SET NOCOUNT ON

	DECLARE @pFecha_Desde		DATE
	DECLARE @pFecha_Hasta		DATE
	DECLARE @Id_Evento_Grupo	INT
	DECLARE @sql				VARCHAR(MAX)
	DECLARE @Inc_Abonos_Grup_Eve VARCHAR(1000)

	SET @pFecha_Desde			= ISNULL(CONVERT(DATE, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), CONVERT(DATE,GETDATE()))
	SET @pFecha_Hasta			= ISNULL(CONVERT(DATE, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), CONVERT(DATE,GETDATE()))
	SET @Id_Evento_Grupo		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Evento_Grupo')), 0)

	SET @pFecha_Hasta = DATEADD(DAY,1,@pFecha_Hasta)

BEGIN TRY

	SELECT * INTO #LISTAS FROM Prod_Listas_Precios WHERE Id_Evento_Grupo = @Id_Evento_Grupo
	SELECT @Inc_Abonos_Grup_Eve = Inc_Abonos_Grup_Eve FROM Eventos_Grupos WHERE Id_Evento_Grupo = @Id_Evento_Grupo
	SET @sql = 'INSERT INTO #LISTAS
					SELECT *   
						FROM Prod_Listas_Precios P 
						WHERE Id_Evento_Grupo IN (' + @Inc_Abonos_Grup_Eve +')
						AND NOT EXISTS (SELECT 1 FROM #LISTAS L WHERE L.Id_Lista_Precio = P.Id_Lista_Precio)' 
    EXEC(@sql) 



	SELECT i.id_producto, COUNT(*) AS Cantidad
	INTO #zDuplicados_20220317_3
	FROM cbtes c, cbtes_items i, Clientes T, Productos P, Empresas_Sedes_Sectores Sec
	WHERE 
	c.id_trans=i.id_trans
	AND c.id_lista IN (SELECT Id_Lista_Precio FROM #LISTAS)
	AND c.Id_Estado_Cbte not in (0, 3)
	AND T.Id_Cliente = I.Id_Cliente
	AND T.Activo = 1
	AND CONVERT(DATE, i.fecha_qa) < @pFecha_Hasta
	AND CONVERT(DATE, i.fecha_venc) >= @pFecha_Desde
	AND Flag_QA = 'A'
	AND P.Id_Producto = I.Id_Producto
	AND Sec.Id_Sector = P.Id_Sector
	AND Sec.Flag_Ubic_Fija = 1
	GROUP BY i.id_producto
	HAVING COUNT(*) > 1

	SELECT c.id_trans, dbo.CF_Cbte_Descrip(C.Id_Trans) AS Cbte, C.Lote, CONVERT(DATE, c.fecha) AS Fecha_Cbte, E.Descripcion, c.id_lista, PLP.Descripcion AS Lista,  CONVERT(DATE, i.fecha_qa) AS Fecha_Desde, CONVERT(DATE, i.fecha_venc) AS Fecha_Hasta, i.id_cliente, t.razon_social, i.id_producto, PR.Descripcion_Detallada AS Producto, PR.Calle AS Sector, PR.Fila, PR.Columna AS Asiento, PR.Id_Sector,
		CASE
			WHEN CONVERT(VARCHAR(250),t.Email_Web) IS NOT NULL AND CONVERT(VARCHAR(250),t.Email_Web) <> '' THEN t.Email_Web
			WHEN CONVERT(VARCHAR(250),t.Email) IS NOT NULL AND CONVERT(VARCHAR(250),t.Email) <> '' THEN t.Email
			ELSE 'Sin email'
		END AS Email,
	  CASE
			WHEN CONVERT(VARCHAR(250),t.telefono) IS NOT NULL AND CONVERT(VARCHAR(250),t.telefono) <> '' THEN t.telefono
			WHEN CONVERT(VARCHAR(250),t.Tel_Movil) IS NOT NULL AND CONVERT(VARCHAR(250),t.Tel_Movil) <> '' THEN t.Tel_Movil
			ELSE 'Sin telfono'
	  END AS Telefono
	INTO #zDupl_20220317_3
	FROM cbtes c, cbtes_items i, clientes t, Prod_Listas_Precios PLP, Productos PR, Cbtes_Estados E
	WHERE 
	c.id_trans=i.id_trans
	AND i.id_cliente=t.id_cliente
	AND C.Id_Estado_Cbte = E.Id_Estado_Cbte
	AND PR.Id_Producto = I.Id_Producto
	AND C.Id_Lista = PLP.Id_Lista_Precio
	AND Flag_QA = 'A'
	AND I.Id_Producto <> ''
	and i.Id_Producto in (SELECT id_producto FROM #zDuplicados_20220317_3)
	AND c.Id_Estado_Cbte not in (0, 3)
	AND c.id_lista IN (SELECT Id_Lista_Precio FROM Prod_Listas_Precios WHERE Id_Lista_Precio in (SELECT Id_Lista_Precio FROM #LISTAS))
	AND CONVERT(DATE, i.fecha_qa) < @pFecha_Hasta
	AND CONVERT(DATE, i.fecha_venc) >= @pFecha_Desde
	ORDER BY I.Id_Producto

	SELECT DISTINCT Id_Cliente, A.Cbte, A.Descripcion AS Estado_Cbte, Razon_Social, Id_Producto, Fecha_Cbte, Id_Lista, Lote, t.Id_Trans, a.Id_Sector, CONVERT(VARCHAR(250),a.Email) AS Email, CONVERT(VARCHAR(250),a.Telefono) as Telefono
	FROM #zDupl_20220317_3 a, transacciones t,Cbtes_Aplica ca
	where a.Id_Trans = t.Id_Trans
	and ca.Id_Trans=t.Id_Trans
	and a.Id_Trans=ca.Id_Trans
	ORDER BY Id_Producto, t.Id_Trans

	IF OBJECT_ID('tempdb..#Listas') IS NOT NULL
		DROP TABLE #Listas


END TRY  
BEGIN CATCH  

    EXECUTE usp_GetErrorInfo

	IF OBJECT_ID('tempdb..#Listas') IS NOT NULL
		DROP TABLE #Listas


	RETURN 9999

END CATCH

RETURN 0